<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Checkout | ' . SITE_NAME;
$meta_description = 'Secure checkout to complete your printer order.';

cart_init();

$cartItems = cart_items();
$orderPlaced = false;
$orderId = '';

if (empty($cartItems)) {
    redirect('cart.php');
}

$total = 0;
foreach ($cartItems as $item) {
    $total += $item['price'];
}

/* Handle COD order */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['payment_method']) && $_POST['payment_method'] === 'cod') {
    $orderId = generate_order_id();
    $orderPlaced = true;
    cart_clear();
}

include 'includes/header.php';
?>

<!-- 🔹 CHECKOUT HERO -->
<section class="checkout-hero">
  <div class="container">
    <h1>Checkout</h1>
    <p>Secure checkout for your printer order</p>
  </div>
</section>

<!-- 🔹 CHECKOUT CONTENT -->
<section class="checkout-section">
  <div class="container">

    <?php if ($orderPlaced): ?>

      <!-- SUCCESS -->
      <div class="checkout-success">
        <h2>Thank You for Your Order!</h2>
        <p>Your order has been placed successfully.</p>
        <p><strong>Order ID:</strong> <?= $orderId ?></p>

        <a href="track-order.php" class="checkout-btn">
          Track Your Order
        </a>
      </div>

    <?php else: ?>

    <form method="post" id="checkoutForm">
      <div class="row">

        <!-- BILLING DETAILS -->
        <div class="col-md-7">
          <div class="checkout-box">

            <h3>Billing & Shipping Details</h3>

            <div class="row">
              <div class="col-md-6">
                <input type="text" name="name" placeholder="Full Name" required>
              </div>
              <div class="col-md-6">
                <input type="email" name="email" placeholder="Email Address" required>
              </div>
            </div>

            <input type="text" name="phone" placeholder="Phone Number" required>
            <input type="text" name="address" placeholder="Shipping Address" required>

            <div class="row">
              <div class="col-md-6">
                <input type="text" name="city" placeholder="City" required>
              </div>
              <div class="col-md-6">
                <input type="text" name="state" placeholder="State" required>
              </div>
            </div>

            <input type="text" name="zip" placeholder="ZIP / Postal Code" required>

            <!-- PAYMENT METHOD -->
            <div class="payment-method">
  <h4>Payment Method</h4>

  <p class="payment-note">
  All prices are displayed in USD. No hidden fees.
</p>

  <label class="payment-option">
    <input type="radio" name="payment_method" value="cod" checked>
    <div class="payment-card">
      <div class="payment-icon">💵</div>
      <div class="payment-text">
        <strong>Cash on Delivery</strong>
        <span>Pay when your printer is delivered</span>
      </div>
    </div>
  </label>

  <label class="payment-option">
    <input type="radio" name="payment_method" value="paypal">
    <div class="payment-card">
      <div class="payment-icon">🅿️</div>
      <div class="payment-text">
        <strong>Pay with PayPal</strong>
        <span>Secure online payment via PayPal</span>
      </div>
    </div>
  </label>
</div>


          </div>
        </div>

        <!-- ORDER SUMMARY -->
        <div class="col-md-5">
          <div class="checkout-box">

            <h3>Your Order</h3>

            <ul class="order-summary">
              <?php foreach ($cartItems as $item): ?>
                <li>
                  <?= e($item['name']) ?>
                  <span><?= price($item['price']) ?></span>
                </li>
              <?php endforeach; ?>
            </ul>

            <div class="order-total">
              <p>
                <strong>Total</strong>
                <span><?= price($total) ?></span>
              </p>
            </div>

            <!-- COD BUTTON -->
            <button type="submit" class="checkout-btn" id="codBtn">
              Place Order
            </button>

            <!-- PAYPAL BUTTON -->
            <div id="paypal-button-container" style="display:none; margin-top:15px;"></div>

            <div class="checkout-trust">
              🔒 Secure Checkout &nbsp; | &nbsp; 📦 Genuine Printers
            </div>

          </div>
        </div>

      </div>
    </form>

    <?php endif; ?>

  </div>
</section>

<!-- PAYPAL SDK -->
<script src="https://www.paypal.com/sdk/js?client-id=AUoFsNuR_bamDCo32a2D9htB4a1z1DhFqgBLVcp8mBI6FfYESpbkBgi4o3OfMElhK7J1_P3OKJzRW5dT&currency=USD"></script>

<script>
const paypalBox = document.getElementById('paypal-button-container');
const codBtn = document.getElementById('codBtn');
const paymentRadios = document.querySelectorAll('input[name="payment_method"]');

paymentRadios.forEach(radio => {
  radio.addEventListener('change', () => {
    if (radio.value === 'paypal' && radio.checked) {
      paypalBox.style.display = 'block';
      codBtn.style.display = 'none';
    } else {
      paypalBox.style.display = 'none';
      codBtn.style.display = 'block';
    }
  });
});

paypal.Buttons({
  createOrder: function(data, actions) {
    return actions.order.create({
      purchase_units: [{
        amount: {
          value: "<?= number_format($total, 2, '.', '') ?>"
        }
      }]
    });
  },

  onApprove: function(data, actions) {
    return actions.order.capture().then(function(details) {
      window.location.href = "order-success.php?paypal=1";
    });
  },

  onCancel: function () {
    alert('Payment cancelled. You can choose Cash on Delivery.');
  }

}).render('#paypal-button-container');
</script>

<?php include 'includes/footer.php'; ?>
