<?php
// Start session safely
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/*
|--------------------------------------------------------------------------
| SITE BASIC INFO
|--------------------------------------------------------------------------
*/
define('SITE_NAME', 'Lopez Generic');
define('SITE_TAGLINE', 'Quality Products. Trusted Service.');

define('SITE_EMAIL', 'info@lopezgeneric.com');
define('SITE_PHONE', '+1-678-972-6493');
define('SITE_ADDRESS', '1315 Sunnyside Road, Thomaston, Georgia, United States, 30286');

/*
|--------------------------------------------------------------------------
| BASE URL
|--------------------------------------------------------------------------
| LOCALHOST SETUP
*/
define('BASE_URL', 'https://lopezgeneric.com');

/*
|--------------------------------------------------------------------------
| CURRENCY SETTINGS
|--------------------------------------------------------------------------
*/
define('CURRENCY_SYMBOL', '$');
define('CURRENCY_CODE', 'USD');

/*
|--------------------------------------------------------------------------
| SESSION KEYS
|--------------------------------------------------------------------------
*/
define('SESSION_CART_KEY', 'cart');
define('SESSION_USER_KEY', 'user');

/*
|--------------------------------------------------------------------------
| ORDER SETTINGS
|--------------------------------------------------------------------------
*/
define('ORDER_PREFIX', 'ORD');
define('ALLOW_GUEST_CHECKOUT', true);

/*
|--------------------------------------------------------------------------
| SITE MODE
|--------------------------------------------------------------------------
*/
define('SITE_LIVE', false); // set true on production

/*
|--------------------------------------------------------------------------
| TIMEZONE
|--------------------------------------------------------------------------
*/
date_default_timezone_set('Asia/Kolkata');

/*
|--------------------------------------------------------------------------
| ERROR REPORTING
|--------------------------------------------------------------------------
*/
if (SITE_LIVE) {
    error_reporting(0);
    ini_set('display_errors', 0);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}
