<?php
// Prevent direct access
if (!defined('BASE_URL')) {
    die('Direct access not allowed');
}

/*
|--------------------------------------------------------------------------
| SECURITY & HELPERS
|--------------------------------------------------------------------------
*/
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

/*
|--------------------------------------------------------------------------
| PRICE FORMAT
|--------------------------------------------------------------------------
*/
function price($amount) {
    return CURRENCY_SYMBOL . number_format((float)$amount, 2);
}

/*
|--------------------------------------------------------------------------
| CART FUNCTIONS (SESSION BASED)
|--------------------------------------------------------------------------
*/
function cart_init() {
    if (!isset($_SESSION[SESSION_CART_KEY])) {
        $_SESSION[SESSION_CART_KEY] = [];
    }
}

function cart_add($product) {
    cart_init();
    $_SESSION[SESSION_CART_KEY][] = $product;
}

function cart_items() {
    return $_SESSION[SESSION_CART_KEY] ?? [];
}

function cart_count() {
    return count(cart_items());
}

function cart_clear() {
    unset($_SESSION[SESSION_CART_KEY]);
}

/*
|--------------------------------------------------------------------------
| ORDER FUNCTIONS
|--------------------------------------------------------------------------
*/
function generate_order_id() {
    return ORDER_PREFIX . '-' . strtoupper(uniqid());
}

/*
|--------------------------------------------------------------------------
| USER AUTH (SESSION BASED – NO DB)
|--------------------------------------------------------------------------
*/
function is_logged_in() {
    return isset($_SESSION[SESSION_USER_KEY]);
}

function login_user($user) {
    $_SESSION[SESSION_USER_KEY] = $user;
}

function logout_user() {
    unset($_SESSION[SESSION_USER_KEY]);
}

/*
|--------------------------------------------------------------------------
| REDIRECT
|--------------------------------------------------------------------------
*/
function redirect($path) {
    header("Location: " . BASE_URL . "/" . ltrim($path, '/'));
    exit;
}

/*
|--------------------------------------------------------------------------
| MAINTENANCE MODE
|--------------------------------------------------------------------------
*/
function check_site_status() {
    if (!SITE_LIVE) {
        return;
    }
}
