<?php
if (!defined('BASE_URL')) {
    die('Direct access not allowed');
}
// Build canonical URL safely
$canonical = BASE_URL . $_SERVER['PHP_SELF'];

if (!empty($_GET)) {
    // Remove tracking/search params from canonical
    $allowedParams = ['id']; // only product ID allowed
    $filtered = array_intersect_key($_GET, array_flip($allowedParams));
    if (!empty($filtered)) {
        $canonical .= '?' . http_build_query($filtered);
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($page_title ?? SITE_NAME) ?></title>
<meta name="description" content="<?= htmlspecialchars($meta_description ?? '') ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="icon" type="image/x-icon" href="assets/images/favicon.ico">

<link rel="canonical" href="<?= htmlspecialchars($canonical) ?>">

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Font Awesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<!-- Main CSS -->
<link href="<?= BASE_URL ?>/assets/css/style.css" rel="stylesheet">

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Lopez Generic",
  "url": "https://www.lopezgeneric.com",
  "logo": "https://www.lopezgeneric.com/assets/images/logo.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+1-678-972-6493",
    "contactType": "customer support",
    "email": "info@lopezgeneric.com"
  },
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "1315 Sunnyside Road",
    "addressLocality": "Thomaston",
    "addressRegion": "Georgia",
    "postalCode": "30286",
    "addressCountry": "US"
  }
}
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebSite",
  "name": "Lopez Generic",
  "url": "https://www.lopezgeneric.com",
  "potentialAction": {
    "@type": "SearchAction",
    "target": "https://www.lopezgeneric.com/shop.php?q={search_term_string}",
    "query-input": "required name=search_term_string"
  }
}
</script>


</head>
<body>

<!-- 🔹 TOP BAR -->
<div class="top-bar">
  <div class="container d-flex justify-content-between flex-wrap">
    <div class="top-left">
      <span><i class="fa-solid fa-envelope"></i> <?= SITE_EMAIL ?></span>
      <span><i class="fa-solid fa-phone"></i> <?= SITE_PHONE ?></span>
    </div>
    <div class="top-right">
      <span><i class="fa-solid fa-location-dot"></i> <?= SITE_ADDRESS ?></span>
    </div>
  </div>
</div>

<!-- 🔹 MAIN HEADER -->
<nav class="navbar navbar-expand-lg header-main">
  <div class="container">

    <!-- Logo -->
    <a class="navbar-brand site-logo" href="<?= BASE_URL ?>">
        <?= SITE_NAME ?>
    </a>

    <!-- Mobile Toggle -->
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Navigation -->
    <div class="collapse navbar-collapse" id="mainNav">

      <ul class="navbar-nav mx-auto main-menu">
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>">Home</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/about.php">About Us</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/shop.php">Shop</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= BASE_URL ?>/contact.php">Contact Us</a></li>
      </ul>

      <!-- Search -->
      <form class="search-form" method="get" action="shop.php">
        <input type="search" name="q" placeholder="Search products">
      </form>

      <!-- Icons -->
      <div class="header-icons">

  <?php if (isset($_SESSION[SESSION_USER_KEY])): ?>

    <!-- Logged-in user -->
    <a href="my-account.php" title="My Account">
      <i class="fa-solid fa-user"></i>
    </a>

    <a href="logout.php" title="Logout">
      <i class="fa-solid fa-right-from-bracket"></i>
    </a>

  <?php else: ?>

    <!-- Guest -->
    <a href="login.php" title="Login">
      <i class="fa-solid fa-user"></i>
    </a>

  <?php endif; ?>

  <a href="cart.php" title="Cart" class="cart-icon">
    <i class="fa-solid fa-cart-shopping"></i>
    <span class="cart-count">
      <?= isset($_SESSION[SESSION_CART_KEY]) ? count($_SESSION[SESSION_CART_KEY]) : 0 ?>
    </span>
  </a>

</div>


    </div>
  </div>
</nav>
