<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Return Your Order | ' . SITE_NAME;
$meta_description = 'Request a return for your printer order using your order ID.';

$submitted = false;
$orderId = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orderId = trim($_POST['order_id']);
    if (!empty($orderId)) {
        $submitted = true;
    }
}

include 'includes/header.php';
?>

<!-- 🔹 RETURN HERO -->
<section class="return-hero">
  <div class="container">
    <h1>Return Your Order</h1>
    <p>Submit a return request for an eligible printer order.</p>
  </div>
</section>

<!-- 🔹 RETURN SECTION -->
<section class="return-section">
  <div class="container">

    <div class="return-box">

      <?php if ($submitted): ?>

        <div class="return-success">
          <h3>Return Request Submitted</h3>
          <p>
            Your return request for order
            <strong><?= e($orderId) ?></strong> has been received.
          </p>
          <p>
            Our team will review your request and contact you with
            further instructions if the order is eligible for return.
          </p>
          <a href="contact.php" class="return-btn">
            Contact Support
          </a>
        </div>

      <?php else: ?>

        <form method="post">

          <input
            type="text"
            name="order_id"
            placeholder="Enter Order ID (e.g. ORD-XXXXXX)"
            required
          >

          <select name="reason" required>
            <option value="">Select Return Reason</option>
            <option value="damaged">Product arrived damaged</option>
            <option value="wrong-item">Received wrong product</option>
            <option value="not-needed">Product no longer needed</option>
            <option value="other">Other reason</option>
          </select>

          <textarea
            name="message"
            rows="4"
            placeholder="Additional details (optional)"
          ></textarea>

          <button type="submit" class="return-btn">
            Submit Return Request
          </button>

        </form>

      <?php endif; ?>

    </div>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
