<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'About Us | ' . SITE_NAME;
$meta_description = 'Learn more about our printer-focused online store, our values, and our commitment to quality and customer satisfaction.';

include 'includes/header.php';
?>

<!-- 🔹 ABOUT HERO -->
<section class="about-hero">
  <div class="container">
    <h1>About <?= SITE_NAME ?></h1>
    <p>
      A dedicated online store for reliable printers and practical printing solutions.
    </p>
  </div>
</section>

<!-- 🔹 ABOUT CONTENT -->
<section class="about-page-section">
  <div class="container">

    <div class="about-page-content">

      <span class="about-page-subtitle">Who We Are</span>
      <h2>Your Trusted Online Printer Store</h2>

      <p>
        <?= SITE_NAME ?> is a specialized eCommerce platform focused exclusively on
        printers and essential printing solutions for home users, professionals,
        and businesses. We created this store to make printer shopping simple,
        transparent, and reliable.
      </p>

      <p>
        Unlike general marketplaces, our store concentrates only on printers.
        This allows us to present clear product information, relevant categories,
        and practical guidance so customers can confidently choose the right printer
        based on their needs.
      </p>

      <p>
        Our product range includes inkjet printers, laser printers, all-in-one devices,
        and wireless printing solutions from trusted manufacturers. Every product
        listed on our website is selected with performance, durability, and usability
        in mind.
      </p>

      <span class="about-page-subtitle">Our Commitment</span>
      <h3>Quality, Transparency, and Customer Satisfaction</h3>

      <p>
        We believe that buying a printer should not be confusing or stressful.
        That is why we focus on honest product descriptions, clear pricing, and
        straightforward policies. What you see on our website is exactly what
        you receive.
      </p>

      <p>
        From browsing products to completing checkout, our platform is designed
        to provide a smooth and secure shopping experience. Our goal is to build
        long-term trust by delivering reliable products and dependable service.
      </p>

      <span class="about-page-subtitle">Why Choose Us</span>
      <h3>A Store Built Around Printing Needs</h3>

      <p>
        Whether you need a compact printer for home use or a high-performance
        machine for office workloads, we are here to help you make an informed
        decision. Our focus on printers allows us to better understand customer
        requirements and deliver solutions that truly fit.
      </p>

      <a href="shop.php" class="about-page-btn">
        Explore Our Printers
      </a>

    </div>
  </div>
</section>

<?php include 'includes/footer.php'; ?>
