<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Your Cart | ' . SITE_NAME;
$meta_description = 'Review the printers added to your cart before checkout.';

cart_init();

// Handle remove item
if (isset($_GET['remove'])) {
    $removeIndex = (int) $_GET['remove'];
    if (isset($_SESSION[SESSION_CART_KEY][$removeIndex])) {
        unset($_SESSION[SESSION_CART_KEY][$removeIndex]);
        $_SESSION[SESSION_CART_KEY] = array_values($_SESSION[SESSION_CART_KEY]);
    }
}

// Dummy products (since no DB)
$cartItems = cart_items();

include 'includes/header.php';
?>

<!-- 🔹 CART HERO -->
<section class="cart-hero">
  <div class="container">
    <h1>Your Shopping Cart</h1>
    <p>Review your selected printers before proceeding to checkout.</p>
  </div>
</section>

<!-- 🔹 CART CONTENT -->
<section class="cart-section">
  <div class="container">

    <?php if (empty($cartItems)): ?>

      <div class="cart-empty">
        <p>Your cart is currently empty.</p>
        <a href="shop.php" class="cart-btn">Continue Shopping</a>
      </div>

    <?php else: ?>

    <div class="cart-wrapper">

      <table class="cart-table">
        <thead>
          <tr>
            <th>Product</th>
            <th>Price</th>
            <th>Remove</th>
          </tr>
        </thead>
        <tbody>

          <?php
          $total = 0;
          foreach ($cartItems as $index => $item):
              $total += $item['price'];
          ?>
          <tr>
            <td>
              <strong><?= e($item['name']) ?></strong>
            </td>
            <td><?= price($item['price']) ?></td>
            <td>
              <a href="cart.php?remove=<?= $index ?>" class="remove-item">Remove</a>
            </td>
          </tr>
          <?php endforeach; ?>

        </tbody>
      </table>

      <div class="cart-summary">
        <p>
          <strong>Subtotal:</strong>
          <span><?= price($total) ?></span>
        </p>

        <a href="checkout.php" class="cart-btn">
          Proceed to Checkout
        </a>
      </div>

    </div>

    <?php endif; ?>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
