<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Contact Us | ' . SITE_NAME;
$meta_description = 'Contact our printer store for product inquiries, order help, or general questions.';

$success = false;

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // We are not storing anything (session-based demo)
    $success = true;
}

include 'includes/header.php';
?>

<!-- 🔹 CONTACT HERO -->
<section class="contact-hero">
  <div class="container">
    <h1>Contact Us</h1>
    <p>We’re here to help with your printer-related questions.</p>
  </div>
</section>

<!-- 🔹 CONTACT CONTENT -->
<section class="contact-section">
  <div class="container">

    <div class="row">

      <!-- CONTACT INFO -->
      <div class="col-md-5">
        <div class="contact-info">

          <h3>Get in Touch</h3>
          <p>
            If you have questions about printers, orders, or our policies,
            feel free to reach out using the contact details below.
          </p>

          <ul>
            <li>
              <strong>Address:</strong><br>
              <?= SITE_ADDRESS ?>
            </li>
            <li>
              <strong>Email:</strong><br>
              <a href="mailto:<?= SITE_EMAIL ?>"><?= SITE_EMAIL ?></a>
            </li>
            <li>
              <strong>Phone:</strong><br>
              <a href="tel:<?= SITE_PHONE ?>"><?= SITE_PHONE ?></a>
            </li>
          </ul>

        </div>
      </div>

      <!-- CONTACT FORM -->
      <div class="col-md-7">
        <div class="contact-form">

          <h3>Send Us a Message</h3>

          <?php if ($success): ?>
            <div class="contact-success">
              Thank you for contacting us. We have received your message and
              will get back to you shortly.
            </div>
          <?php else: ?>

          <form method="post">

            <div class="row">
              <div class="col-md-6">
                <input type="text" name="name" placeholder="Your Name" required>
              </div>
              <div class="col-md-6">
                <input type="email" name="email" placeholder="Your Email" required>
              </div>
            </div>

            <input type="text" name="subject" placeholder="Subject" required>

            <textarea name="message" rows="5" placeholder="Your Message" required></textarea>

            <button type="submit" class="contact-btn">
              Submit Message
            </button>

          </form>

          <?php endif; ?>

        </div>
      </div>

    </div>
  </div>
</section>

<?php include 'includes/footer.php'; ?>
