<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Shop Quality Products Online';
$meta_description = 'Shop quality products with fast shipping and easy checkout.';

include 'includes/header.php';

/* Get first 12 active products */
$featuredProducts = array_slice(get_all_products(), 0, 12);

/* Helper: trim description */
function trim_words($text, $limit = 15) {
    $words = preg_split('/\s+/', strip_tags($text));
    return count($words) > $limit
        ? implode(' ', array_slice($words, 0, $limit)) . '...'
        : $text;
}
?>

<!-- 🔹 HERO SECTION -->
<section class="hero-section">
  <div class="container">
    <div class="row align-items-center">

      <!-- LEFT CONTENT -->
      <div class="col-md-6">
        <div class="hero-content">

          <span class="hero-subtitle">
            Printers • Ink • Office Printing Solutions
          </span>

          <h1 class="hero-title">
            Buy Reliable Printers for Home & Office
          </h1>

          <p class="hero-description">
            Shop high-quality inkjet and laser printers with genuine supplies,
            fast delivery, and secure checkout — all in one trusted place.
          </p>

          <a href="shop.php" class="hero-btn">
            Shop Printers
          </a>

        </div>
      </div>

      <!-- RIGHT IMAGE -->
      <div class="col-md-6 text-center">
        <div class="hero-image">
          <img
            src="assets/images/hero-printer.png"
            alt="Printer for Home and Office"
          >
        </div>
      </div>

    </div>
  </div>
</section>



<!-- 🔹 CATEGORY SECTION -->
<section class="category-section">
  <div class="container">

    <div class="section-header">
      <h2>Shop Printers by Category</h2>
      <p>
        Choose the right printer for your home or office needs.
        All categories include genuine products with full warranty.
      </p>
    </div>

    <div class="row">

      <div class="col-md-3">
        <a href="shop.php?category=home-printer" class="category-card">
          <h3>Home Printers</h3>
          <span>Best for home & personal use</span>
        </a>
      </div>

      <div class="col-md-3">
        <a href="shop.php?category=office-printer" class="category-card">
          <h3>Office Printers</h3>
          <span>Reliable printers for office work</span>
        </a>
      </div>

      <div class="col-md-3">
        <a href="shop.php?tech=Inkjet" class="category-card">
          <h3>Inkjet Printers</h3>
          <span>Great for photos & color printing</span>
        </a>
      </div>

      <div class="col-md-3">
        <a href="shop.php?tech=Laser" class="category-card">
          <h3>Laser Printers</h3>
          <span>Fast, efficient & cost-effective</span>
        </a>
      </div>

    </div>

  </div>
</section>


<!-- 🔹 FEATURED PRODUCTS -->
<section class="featured-section">
  <div class="container">

    <div class="section-header">
      <h2>Featured Printers</h2>
      <p>
        Top-selling and reliable printers carefully selected for home and office use.
      </p>
    </div>

    <div class="row">

      <?php foreach ($featuredProducts as $product): ?>

      <div class="col-md-3 cols-pro">
        <div class="product-card">

          <div class="product-image">
            <a href="product.php?id=<?= $product['id'] ?>">
              <img
                src="<?= $product['imageUrl'] ?>"
                alt="<?= e($product['name']) ?>"
              >
            </a>
          </div>

          <h3 class="product-title">
            <a href="product.php?id=<?= $product['id'] ?>">
              <?= e($product['name']) ?>
            </a>
          </h3>

          <p class="product-desc">
            <?= e(trim_words($product['description'], 15)) ?>
          </p>

          <div class="product-tags">
            <?php
            $tags = !empty($product['features'])
                ? array_map('trim', explode(',', $product['features']))
                : [];
            foreach ($tags as $tag):
            ?>
              <span><?= e($tag) ?></span>
            <?php endforeach; ?>
          </div>

          <div class="product-bottom">
            <span class="product-price">
              <?= price((float)$product['price']) ?>
            </span>

            <a
              href="shop.php?add=<?= $product['id'] ?>"
              class="add-to-cart-btn"
            >
              Add to Cart
            </a>
          </div>

        </div>
      </div>

      <?php endforeach; ?>

    </div>

  </div>
</section>

<!-- 🔹 ABOUT US SECTION -->
<section class="about-section">
  <div class="container">

    <div class="about-wrapper">

      <div class="about-content">
        <span class="about-subtitle">
          About Our Store
        </span>

        <h2 class="about-title">
          A Dedicated Online Store for Quality Printers
        </h2>

        <p>
          We are a specialized eCommerce store focused exclusively on printers and
          printing solutions for home users, small businesses, and offices.
          Our goal is to make printer shopping simple, transparent, and reliable.
        </p>

        <p>
          Every printer listed on our website is carefully selected based on
          performance, durability, and real user needs. We offer inkjet,
          laser, all-in-one, and wireless printers from trusted manufacturers,
          ensuring genuine products and clear pricing.
        </p>

        <p>
          With secure checkout, responsive customer assistance, and fast order
          processing, we aim to provide a smooth shopping experience from
          product selection to delivery. Whether you need a printer for daily
          home use or office workloads, we are here to help you choose the right one.
        </p>

        <a href="about.php" class="about-btn">
          Learn More About Us
        </a>
      </div>

    </div>
  </div>
</section>

<!-- 🔹 WHY CHOOSE US SECTION -->
<section class="why-choose-section">
  <div class="container">

    <div class="section-header">
      <h2>Why Choose Our Printer Store</h2>
      <p>
        We focus on quality, transparency, and customer satisfaction at every step.
      </p>
    </div>

    <div class="row align-items-center">

      <!-- LEFT IMAGE -->
      <div class="col-md-6">
        <div class="why-image">
          <img src="assets/images/why-choose-printers.jpg" alt="Reliable Printer Store">
        </div>
      </div>

      <!-- RIGHT FAQ -->
      <div class="col-md-6">

        <div class="accordion" id="whyChooseAccordion">

          <div class="accordion-item">
            <h2 class="accordion-header">
              <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                Do you sell only genuine printers?
              </button>
            </h2>
            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#whyChooseAccordion">
              <div class="accordion-body">
                Yes. Every printer listed on our website is sourced from trusted manufacturers
                and authorized suppliers. We do not deal in refurbished or counterfeit products.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                How do I choose the right printer for my needs?
              </button>
            </h2>
            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#whyChooseAccordion">
              <div class="accordion-body">
                Each product includes clear specifications and usage details.
                Whether you need a printer for home use, office work, or bulk printing,
                our categories and descriptions help you make the right decision.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                Are prices and product details transparent?
              </button>
            </h2>
            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#whyChooseAccordion">
              <div class="accordion-body">
                Absolutely. We display clear pricing, key features, and essential details
                upfront so you know exactly what you are purchasing—no hidden surprises.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                Is checkout and payment secure?
              </button>
            </h2>
            <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#whyChooseAccordion">
              <div class="accordion-body">
                Yes. Our checkout process is secure and designed to protect customer
                information. We follow standard security practices to ensure safe transactions.
              </div>
            </div>
          </div>

        </div>

      </div>
    </div>
  </div>
</section>

<!-- 🔹 TESTIMONIAL SECTION -->
<section class="testimonial-section">
  <div class="container">

    <div class="section-header">
      <h2>What Our Customers Say</h2>
      <p>
        Honest feedback from customers who purchased printers from our store.
      </p>
    </div>

    <div class="row">

      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            “I was looking for a reliable home printer and found exactly what I needed.
            The product details were clear and the checkout process was smooth.”
          </p>
          <div class="testimonial-user">
            <strong>David R.</strong>
            <span>Home User</span>
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            “Good selection of printers and fair pricing. The descriptions helped me
            choose the right laser printer for my office work.”
          </p>
          <div class="testimonial-user">
            <strong>Emily T.</strong>
            <span>Small Business Owner</span>
          </div>
        </div>
      </div>

      <div class="col-md-4">
        <div class="testimonial-card">
          <p class="testimonial-text">
            “Everything was straightforward — from browsing products to placing the order.
            The printer arrived as expected and works perfectly.”
          </p>
          <div class="testimonial-user">
            <strong>Michael S.</strong>
            <span>Office Administrator</span>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>


<?php include 'includes/footer.php'; ?>
