<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Login | ' . SITE_NAME;
$meta_description = 'Login to your account to manage orders and checkout faster.';

$error = false;

// Handle login submit (session-based demo)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Simple demo login (no DB)
    $_SESSION[SESSION_USER_KEY] = [
        'email' => $_POST['email']
    ];
    redirect('index.php');
}

include 'includes/header.php';
?>

<!-- 🔹 LOGIN SECTION -->
<section class="auth-section">
  <div class="container">

    <div class="auth-wrapper">

      <div class="auth-box">
        <h1>Login to Your Account</h1>
        <p>
          Access your account to track orders and manage your purchases.
        </p>

        <?php if ($error): ?>
          <div class="auth-error">
            Invalid login credentials. Please try again.
          </div>
        <?php endif; ?>

        <form method="post">

          <input type="email" name="email" placeholder="Email Address" required>
          <input type="password" name="password" placeholder="Password" required>

          <button type="submit" class="auth-btn">
            Login
          </button>

        </form>

        <div class="auth-links">
          <a href="forgot-password.php">Forgot Password?</a>
          <span>|</span>
          <a href="signup.php">Create an Account</a>
        </div>
      </div>

    </div>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
