<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

if (!is_logged_in()) {
    redirect('login.php');
}

$user = $_SESSION[SESSION_USER_KEY];

$page_title = 'My Account | ' . SITE_NAME;
$meta_description = 'Manage your account, track orders, and logout securely.';

include 'includes/header.php';
?>

<!-- 🔹 ACCOUNT HERO -->
<section class="account-hero">
  <div class="container">
    <h1>My Account</h1>
    <p>Manage your account and orders</p>
  </div>
</section>

<!-- 🔹 ACCOUNT SECTION -->
<section class="account-section">
  <div class="container">

    <div class="account-box">

      <h3>Account Information</h3>

      <p>
        <strong>Name:</strong>
        <?= isset($user['name']) ? e($user['name']) : 'Customer' ?>
      </p>

      <p>
        <strong>Email:</strong>
        <?= e($user['email']) ?>
      </p>

      <hr>

      <h4>Quick Actions</h4>

      <ul class="account-links">
        <li><a href="track-order.php">Track Your Order</a></li>
        <li><a href="return-order.php">Return an Order</a></li>
        <li><a href="shop.php">Continue Shopping</a></li>
      </ul>

      <a href="logout.php" class="account-logout-btn">
        Logout
      </a>

    </div>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
