<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

cart_init();

/* Get product ID */
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$product = get_product_by_id($id);

/* Redirect if invalid product */
if (!$product || !$product['isActive']) {
    redirect('shop.php');
}

/* Add to cart */
if (isset($_GET['add'])) {
    if ($product['stock'] > 0) {
        cart_add([
            'id'    => $product['id'],
            'name'  => $product['name'],
            'price' => (float)$product['price']
        ]);
        redirect('cart.php');
    }
}

$page_title = $product['seoTitle'] ?: $product['name'] . ' | ' . SITE_NAME;
$meta_description = $product['seoDescription'] ?: $product['description'];

include 'includes/header.php';
?>

<!-- 🔹 PRODUCT HERO -->
<section class="product-hero">
  <div class="container">
    <h1><?= e($product['name']) ?></h1>
    <p><?= e($product['description']) ?></p>
  </div>
</section>

<!-- 🔹 PRODUCT DETAILS -->
<section class="product-section">
  <div class="container">

    <div class="row">

      <!-- IMAGE -->
      <div class="col-md-5">
        <div class="product-image-box">
          <img src="<?= $product['imageUrl'] ?>" alt="<?= e($product['name']) ?>">
        </div>
      </div>

      <!-- INFO -->
      <div class="col-md-7">
        <div class="product-info">

          <h2><?= e($product['name']) ?></h2>

          <p class="product-long-desc">
            <?= e($product['description']) ?>
          </p>

          <!-- FEATURES -->
          <?php if (!empty($product['features'])): ?>
          <div class="product-tags">
            <?php foreach (array_map('trim', explode(',', $product['features'])) as $feature): ?>
              <span><?= e($feature) ?></span>
            <?php endforeach; ?>
          </div>
          <?php endif; ?>

          <div class="product-price-box">
            <span class="product-price">
              <?= price((float)$product['price']) ?>
            </span>
          </div>

          <?php if ($product['stock'] > 0): ?>
            <a href="product.php?id=<?= $product['id'] ?>&add=1" class="product-cart-btn">
              Add to Cart
            </a>
          <?php else: ?>
            <span class="out-of-stock">Out of Stock</span>
          <?php endif; ?>

          <div class="product-trust">
            ✔ Delivery in <?= e($product['deliveryTime']) ?>
            &nbsp; | &nbsp;
            ✔ <?= e($product['warranty']) ?> Warranty
          </div>

        </div>
      </div>

    </div>

    <!-- SPECIFICATIONS -->
    <div class="product-specs">
      <h3>Specifications</h3>

      <table>
        <tr><th>Brand</th><td><?= e($product['brand']) ?></td></tr>
        <tr><th>Technology</th><td><?= e($product['printTechnology']) ?></td></tr>
        <tr><th>Print Speed</th><td><?= e($product['printSpeed']) ?></td></tr>
        <tr><th>Print Quality</th><td><?= e($product['printQuality']) ?></td></tr>
        <tr><th>Paper Sizes</th><td><?= e($product['paperSizes']) ?></td></tr>
        <tr><th>Connectivity</th><td><?= e($product['connectivity']) ?></td></tr>
        <tr><th>Compatibility</th><td><?= e($product['compatibility']) ?></td></tr>
        <tr><th>Weight</th><td><?= e($product['weight']) ?></td></tr>
        <tr><th>Dimensions</th><td><?= e($product['dimensions']) ?></td></tr>
      </table>
    </div>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
