<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Create Account | ' . SITE_NAME;
$meta_description = 'Create an account to shop printers, track orders, and checkout faster.';

$success = false;

// Handle signup submit (session-based demo)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $_SESSION[SESSION_USER_KEY] = [
        'name'  => $_POST['name'],
        'email' => $_POST['email']
    ];
    $success = true;
}

include 'includes/header.php';
?>

<!-- 🔹 REGISTER SECTION -->
<section class="auth-section">
  <div class="container">

    <div class="auth-wrapper">

      <div class="auth-box">
        <h1>Create Your Account</h1>
        <p>
          Register to enjoy faster checkout and easy order tracking.
        </p>

        <?php if ($success): ?>
          <div class="contact-success">
            Your account has been created successfully.
            <br>
            <a href="login.php">Click here to login</a>
          </div>
        <?php else: ?>

        <form method="post">

          <input type="text" name="name" placeholder="Full Name" required>
          <input type="email" name="email" placeholder="Email Address" required>
          <input type="password" name="password" placeholder="Create Password" required>

          <button type="submit" class="auth-btn">
            Create Account
          </button>

        </form>

        <div class="auth-links">
          Already have an account?
          <a href="login.php">Login</a>
        </div>

        <?php endif; ?>

      </div>

    </div>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
