<?php
require 'includes/config.php';
require 'includes/functions.php';
require 'includes/product-functions.php';

$page_title = 'Track Your Order | ' . SITE_NAME;
$meta_description = 'Track your printer order using your order ID.';

$status = null;
$orderId = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orderId = trim($_POST['order_id']);
    if (!empty($orderId)) {
        // Demo order status (since no DB)
        $status = [
            'order_id' => $orderId,
            'state'    => 'Processing',
            'message'  => 'Your order is being prepared for shipment.'
        ];
    }
}

include 'includes/header.php';
?>

<!-- 🔹 TRACK HERO -->
<section class="track-hero">
  <div class="container">
    <h1>Track Your Order</h1>
    <p>Enter your order ID to check the current status of your order.</p>
  </div>
</section>

<!-- 🔹 TRACK SECTION -->
<section class="track-section">
  <div class="container">

    <div class="track-box">

      <form method="post">
        <input
          type="text"
          name="order_id"
          placeholder="Enter Order ID (e.g. ORD-XXXXXX)"
          required
        >
        <button type="submit" class="track-btn">
          Track Order
        </button>
      </form>

      <?php if ($status): ?>
        <div class="track-result">
          <h3>Order Status</h3>

          <p>
            <strong>Order ID:</strong>
            <?= e($status['order_id']) ?>
          </p>

          <p>
            <strong>Status:</strong>
            <?= e($status['state']) ?>
          </p>

          <p class="track-message">
            <?= e($status['message']) ?>
          </p>
        </div>
      <?php endif; ?>

    </div>

  </div>
</section>

<?php include 'includes/footer.php'; ?>
